/*
 * Decompiled with CFR 0.152.
 */
package oracle.ops.verification.framework.engine.task;

import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import oracle.cluster.gns.GNSException;
import oracle.cluster.gns.GNSUtils;
import oracle.cluster.verification.VerificationError;
import oracle.cluster.verification.VerificationException;
import oracle.ops.mgmt.command.Command;
import oracle.ops.mgmt.nativesystem.NativeSystem;
import oracle.ops.mgmt.nativesystem.SystemFactory;
import oracle.ops.mgmt.trace.Trace;
import oracle.ops.verification.framework.VerificationConstants;
import oracle.ops.verification.framework.command.VerificationCommand;
import oracle.ops.verification.framework.engine.ErrorDescription;
import oracle.ops.verification.framework.engine.Result;
import oracle.ops.verification.framework.engine.ResultSet;
import oracle.ops.verification.framework.engine.task.MultiTaskHandler;
import oracle.ops.verification.framework.engine.task.ODNSDOutputMonitor;
import oracle.ops.verification.framework.engine.task.Task;
import oracle.ops.verification.framework.global.GlobalExecution;
import oracle.ops.verification.framework.global.GlobalHandler;
import oracle.ops.verification.framework.param.ParamManager;
import oracle.ops.verification.framework.param.UninitializedParamManagerException;
import oracle.ops.verification.framework.report.ReportUtil;
import oracle.ops.verification.framework.util.CVUAutoUpdateManager;
import oracle.ops.verification.framework.util.CVUHelperUtil;
import oracle.ops.verification.framework.util.RootAutomationNotConfiguredException;
import oracle.ops.verification.framework.util.RootAutomationUtility;
import oracle.ops.verification.framework.util.VerificationUtil;

public class TaskDNSChecks
extends Task
implements VerificationConstants {
    boolean m_mute = false;
    boolean m_server = false;
    boolean m_client = false;
    boolean m_lastClient = false;
    String m_gnsVIP = null;
    String m_gnsIP = null;
    String m_interface = null;
    private final String m_defaultGnsPort = "53";
    String m_gnsPort = "53";
    String m_gnsDomain = null;
    String m_crsctlBinLocation = null;
    String m_localName = null;
    String START_IP_COMMAND = "crsctl start ip -A ";
    String STOP_DNS_COMMAND = "crsctl stop testdns -address ";
    String STOP_IP_COMMAND = "crsctl stop ip -A ";
    String STATUS_IP_COMMAND = "crsctl status ip -A ";
    String QUERY_DNS_COMMAND = "crsctl query dns -name ";
    String ODNSD_COMMAND = "odnsd -logpath ";
    private final String ERRTXT_4000 = "CRS-4000:";
    private final String ERRTXT_4047 = "CRS-4047:";
    private final String ERRTXT_10003 = "CRS-10003:";
    private final String ERRTXT_10004 = "CRS-10004:";
    private final String ERRTXT_10023 = "CRS-10023:";
    private final String ERRTXT_10031 = "CRS-10031:";
    private final String ERRTXT_10032 = "CRS-10032:";
    private final String ERRTXT_10033 = "CRS-10033:";
    private final String ERRTXT_10034 = "CRS-10034:";
    private boolean m_isUnix;
    private boolean m_isRootCredsAvaliable = true;

    public TaskDNSChecks(String[] nodeList) {
        this(nodeList, null, 1);
    }

    public TaskDNSChecks(String[] nodeList, MultiTaskHandler multiTaskHandler) {
        this(nodeList, multiTaskHandler, 1);
    }

    public TaskDNSChecks(String[] nodeList, MultiTaskHandler multiTaskHandler, int actionOnCompletion) {
        super(nodeList, multiTaskHandler, actionOnCompletion);
        NativeSystem nativeSystem = new SystemFactory().CreateSystem();
        this.m_isUnix = nativeSystem.isUnixSystem();
    }

    @Override
    public String getDefaultDescription() {
        return s_msgBundle.getMessage("5825", false);
    }

    @Override
    public String getDefaultElementName() {
        return s_msgBundle.getMessage("5824", false);
    }

    @Override
    public boolean performTask() {
        if (!this.getCmdLineParams()) {
            return false;
        }
        boolean status = true;
        boolean ipReachable = false;
        try {
            this.m_localName = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException uhe) {
            Trace.out((String)("UNKNOWNHOSTEXCEPTION: while getting local node" + uhe));
            String msg = s_msgBundle.getMessage("0002", true);
            ReportUtil.printError(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        if (this.m_isUnix) {
            try {
                Trace.out((String)"getting root automation configuration");
                if (RootAutomationUtility.isRootExecutionConfigured()) {
                    this.m_rootCreds = RootAutomationUtility.getRootExecutionInfo();
                    this.m_lastClient = true;
                } else {
                    this.m_nodeList = new String[1];
                    this.m_nodeList[0] = this.m_localName;
                    this.m_isRootCredsAvaliable = false;
                }
            }
            catch (VerificationException e) {
                Trace.out((String)"root automation not configured");
                ReportUtil.sureprintln(e.getMessage());
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(errDesc);
                return false;
            }
        }
        this.m_crsctlBinLocation = CVUAutoUpdateManager.getCRSCTLHome();
        if (this.m_crsctlBinLocation == null) {
            String msg = s_msgBundle.getMessage("5301", true);
            ReportUtil.printError(msg);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(errDesc);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            return false;
        }
        Trace.out((String)"checking if gnsd is up on same port");
        if (this.isGNSRunning()) {
            Trace.out((String)"gnsd running on IP and domain we are asked to validate");
            return false;
        }
        if (this.m_server) {
            Trace.out((String)"starting the test dns server");
            ReportUtil.sureprintln(s_msgBundle.getMessage("5800", false, (Object[])new String[]{this.m_gnsVIP, this.m_gnsPort}));
            if (this.performServerSideChecks()) {
                ReportUtil.sureprintln(s_msgBundle.getMessage("5804", false));
                return true;
            }
            ReportUtil.sureprintln(s_msgBundle.getMessage("5805", true));
            return false;
        }
        if (this.m_client) {
            if (status) {
                Trace.out((String)"starting ip reachablility check");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5812", false, (Object[])new String[]{this.m_gnsVIP}));
                if (!this.performIPReachablityCheck()) {
                    Trace.out((String)("ip is not reachable" + this.m_gnsVIP));
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5813", true, (Object[])new String[]{this.m_gnsVIP}));
                    status = false;
                } else {
                    ipReachable = true;
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5814", false, (Object[])new String[]{this.m_gnsVIP}));
                }
            }
            if (status) {
                Trace.out((String)"checking if odnsd is reachable");
                if (!this.performODNSDReachability()) {
                    status = false;
                }
            }
            if (status) {
                Trace.out((String)"Checking if test dns is working");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5815", false, (Object[])new String[]{this.m_gnsVIP, this.m_gnsPort}));
                if (!this.performDirectConnectivityCheck()) {
                    Trace.out((String)"test dns not working");
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5816", true, (Object[])new String[]{this.m_gnsVIP, this.m_gnsPort}));
                    status = false;
                } else {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5817", false, (Object[])new String[]{this.m_gnsVIP, this.m_gnsPort}));
                }
            }
            if (status) {
                Trace.out((String)"Checking DNS delegation for GNS domain");
                ReportUtil.sureprintln(s_msgBundle.getMessage("5818", false, (Object[])new String[]{this.m_gnsDomain}));
                if (!this.performGNSDomainLookup()) {
                    Trace.out((String)"Name resolution via gns is not working");
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5819", true, (Object[])new String[]{this.m_gnsDomain}));
                    status = false;
                } else {
                    ReportUtil.sureprintln(s_msgBundle.getMessage("5820", false, (Object[])new String[]{this.m_gnsDomain}));
                }
            }
            if (ipReachable && this.m_lastClient) {
                Trace.out((String)"sending stop packet to server");
                String stopDNSCmd = this.m_crsctlBinLocation + FILE_SEPARATOR + "bin" + FILE_SEPARATOR + this.STOP_DNS_COMMAND + this.m_gnsIP;
                if (!this.m_gnsPort.equalsIgnoreCase("53")) {
                    stopDNSCmd = stopDNSCmd + " -port " + this.m_gnsPort;
                }
                if (!this.executeCrsctlCommands(stopDNSCmd, crsctlCmdType.StopDNS)) {
                    Trace.out((String)"failed stop testdns");
                    status = false;
                }
            }
        }
        return status;
    }

    private boolean performIPReachablityCheck() {
        boolean status = true;
        String statusIPCmd = this.m_crsctlBinLocation + "bin" + FILE_SEPARATOR + this.STATUS_IP_COMMAND + this.m_gnsIP;
        String[] args = null;
        String[] env = null;
        String output = null;
        HashMap<String, String> nodeOutputMap = new HashMap<String, String>();
        ResultSet locrs = new ResultSet();
        if (!this.m_isUnix || !this.m_isRootCredsAvaliable) {
            int i;
            VerificationCommand[] statusIPCmdArr = new VerificationCommand[this.m_nodeList.length];
            args = new String[]{"-rungencmd", statusIPCmd};
            for (i = 0; i < this.m_nodeList.length; ++i) {
                statusIPCmdArr[i] = new VerificationCommand(this.m_nodeList[i], args, env);
            }
            Trace.out((String)("about to submit cmd : " + statusIPCmd));
            new GlobalHandler().submit((Command[])statusIPCmdArr, 0, locrs);
            this.m_resultSet.uploadResultSet(locrs);
            if (!locrs.anySuccess()) {
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < this.m_nodeList.length; ++i2) {
                    output = statusIPCmdArr[i2].getOutput();
                    if (output == null) continue;
                    sb.append(output + LSEP);
                }
                this.displayGlobalFailureErrMsg(statusIPCmd, sb.toString());
                return false;
            }
            for (i = 0; i < this.m_nodeList.length; ++i) {
                Result result = statusIPCmdArr[i].getResult();
                String node = statusIPCmdArr[i].getNode();
                if (result.getStatus() == 1) {
                    output = statusIPCmdArr[i].getOutput();
                    nodeOutputMap.put(this.m_nodeList[i], output);
                    continue;
                }
                output = statusIPCmdArr[i].getOutput();
                if (output == null) {
                    output = "";
                }
                Trace.out((String)("command failed to execute on node " + node));
                String errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{statusIPCmd, node, output});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
            }
        } else {
            GlobalExecution globalExec = new GlobalExecution();
            boolean rootCmdStatus = false;
            try {
                rootCmdStatus = globalExec.runGenericCmdAsRoot(this.m_nodeList, statusIPCmd, env, args, this.m_rootCreds, this.m_defaultTimeout, locrs);
            }
            catch (RootAutomationNotConfiguredException e) {
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                locrs.addResult(this.m_nodeList, 2);
                locrs.addErrorDescription(errDesc);
                return false;
            }
            this.m_resultSet.uploadResultSet(locrs);
            if (locrs.anySuccess()) {
                Trace.out((String)"root command execution failed");
                for (int i = 0; i < this.m_nodeList.length; ++i) {
                    List<VerificationError> errList = locrs.getResult(this.m_nodeList[i]).getErrors();
                    StringBuilder sb = new StringBuilder();
                    for (VerificationError vfyErr : errList) {
                        sb.append(vfyErr.getErrorMessage());
                    }
                    ErrorDescription errDesc = new ErrorDescription(sb.toString());
                    Trace.out((String)("error on node " + this.m_nodeList[i] + " is " + sb.toString()));
                    this.m_resultSet.addErrorDescription(this.m_nodeList[i], errDesc);
                    ReportUtil.sureprintln(sb.toString());
                }
                return false;
            }
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                Result result = locrs.getResult(this.m_nodeList[i]);
                if (result.getStatus() == 1) {
                    output = (String)locrs.getResult(this.m_nodeList[i]).getResultInfoSet().get(0);
                    nodeOutputMap.put(this.m_nodeList[i], output);
                    continue;
                }
                List<VerificationError> errList = locrs.getResult(this.m_nodeList[i]).getErrors();
                StringBuilder sb = new StringBuilder();
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
                String errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{statusIPCmd, this.m_nodeList[i], ""}) + LSEP + sb.toString();
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                Trace.out((String)("error on node " + this.m_nodeList[i] + " is " + sb.toString()));
                this.m_resultSet.addErrorDescription(this.m_nodeList[i], errDesc);
                ReportUtil.sureprintln(errMsg);
            }
        }
        for (Map.Entry entry : nodeOutputMap.entrySet()) {
            ErrorDescription errDesc;
            String errMsg;
            output = (String)entry.getValue();
            String node = (String)entry.getKey();
            Trace.out((String)("output =" + output));
            if (output == null || output.length() == 0) {
                this.displayNoOutputErrorMsg(statusIPCmd, node);
                status = false;
                continue;
            }
            if (output.indexOf("CRS-10003:") != -1) {
                Trace.out((String)"stat successful");
                this.m_resultSet.addResult(node, 1);
                continue;
            }
            if (output.indexOf("CRS-10004:") != -1 || output.indexOf("CRS-4000:") != -1 || output.indexOf("CRS-4047:") != -1) {
                Trace.out((String)"unable to stat IP");
                this.m_resultSet.addResult(node, 3);
                errMsg = s_msgBundle.getMessage("5821", true, (Object[])new String[]{this.m_gnsVIP}) + LSEP + output;
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
                status = false;
                continue;
            }
            Trace.out((String)("parse error output:" + output));
            errMsg = s_msgBundle.getMessage("5714", true, (Object[])new String[]{statusIPCmd, output});
            this.m_resultSet.addResult(node, 3);
            errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(errMsg);
            status = false;
        }
        return status;
    }

    private boolean performODNSDReachability() {
        String node = this.m_nodeList[0];
        ReportUtil.println(s_gMsgBundle.getMessage("5802", false, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort}));
        try {
            DatagramSocket socket = new DatagramSocket();
            socket.setSoTimeout(3000);
            byte[] sendData = "areYouAliveD6677FD387F7".getBytes();
            DatagramPacket dp = new DatagramPacket(sendData, sendData.length, InetAddress.getByName(this.m_gnsIP), Integer.parseInt(this.m_gnsPort));
            Trace.out((String)"about to send ping packet");
            socket.send(dp);
            byte[] buf = new byte[512];
            dp = new DatagramPacket(buf, buf.length);
            Trace.out((String)"waiting to get response back");
            socket.receive(dp);
            String received = new String(dp.getData(), 0, dp.getLength());
            socket.close();
            Trace.out((String)("Message: " + received));
            if (!received.equals("yesAliveD6677FD387F7")) {
                Trace.out((String)"response doesn't match the expected output");
                String errMsg = s_msgBundle.getMessage("5816", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
                this.m_resultSet.addResult(node, 3);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
            this.m_resultSet.addResult(node, 1);
            ReportUtil.sureprintln(s_gMsgBundle.getMessage("5803", false, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort}));
            Trace.out((String)"odnsd connect successful");
        }
        catch (UnknownHostException e) {
            Trace.out((String)"UHE while looking for odnsd");
            String errMsg = s_msgBundle.getMessage("5816", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
            this.m_resultSet.addResult(node, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        catch (IOException e) {
            Trace.out((String)"IOE while looking for odnsd");
            String errMsg = s_msgBundle.getMessage("5816", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
            this.m_resultSet.addResult(node, 2);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(errMsg);
            return false;
        }
        return true;
    }

    private boolean isGNSRunning() {
        ResultSet gnsResultSet = new ResultSet();
        if (CVUHelperUtil.getGNSDomainAndVIP(gnsResultSet, this.m_localName, true)) {
            String helperGnsIP = null;
            try {
                String helperGnsVIPName = VerificationUtil.getVariableValue("GNS_VIP_ADDRESS");
                Trace.out((String)("helper returned vipname =" + helperGnsVIPName));
                helperGnsIP = InetAddress.getByName(helperGnsVIPName).getHostAddress();
                Trace.out((String)("helper returned ip =" + helperGnsIP));
            }
            catch (UnknownHostException e) {
                Trace.out((String)("UKE shouldn't happen as we get host name from helper" + e.getMessage()));
            }
            String helperSubdomain = VerificationUtil.getVariableValue("GNS_SUB_DOMAIN");
            Trace.out((String)("helper returned subdomain =" + helperSubdomain));
            if (this.m_gnsIP.equalsIgnoreCase(helperGnsIP) && this.m_gnsDomain.equalsIgnoreCase(helperSubdomain)) {
                String errMsg = s_gMsgBundle.getMessage("5818", true, (Object[])new String[]{this.m_gnsVIP, this.m_gnsDomain});
                ReportUtil.sureprintln(errMsg);
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addResult(this.m_nodeList, 2);
                this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
                return true;
            }
        }
        return false;
    }

    private boolean performDirectConnectivityCheck() {
        Trace.out((String)"checking direct look up");
        return this.performDomainNameLookup(this.m_gnsIP);
    }

    private boolean performGNSDomainLookup() {
        Trace.out((String)"checking dns forwarding");
        return this.performDomainNameLookup(null);
    }

    private boolean performDomainNameLookup(String dnsServerAddress) {
        String output;
        boolean status = true;
        String localHost = null;
        try {
            localHost = VerificationUtil.getLocalHost();
        }
        catch (UnknownHostException e) {
            Trace.out((String)"unknown host while getting local host name");
            String errMsg = s_msgBundle.getMessage("0002", true) + e.getMessage();
            ReportUtil.sureprintln(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        String fullHostName = localHost + "." + this.m_gnsDomain;
        String queryDNSCmd = this.m_crsctlBinLocation + "bin" + FILE_SEPARATOR + this.QUERY_DNS_COMMAND + fullHostName + " -v";
        if (dnsServerAddress != null) {
            queryDNSCmd = queryDNSCmd + " -dnsserver " + dnsServerAddress;
        }
        String[] args = null;
        String[] env = null;
        ResultSet locrs = new ResultSet();
        HashMap<String, String> nodeOutputMap = new HashMap<String, String>();
        if (!this.m_isUnix || !this.m_isRootCredsAvaliable) {
            int i;
            VerificationCommand[] queryDNSCmdArr = new VerificationCommand[this.m_nodeList.length];
            args = new String[]{"-rungencmd", queryDNSCmd};
            for (i = 0; i < this.m_nodeList.length; ++i) {
                queryDNSCmdArr[i] = new VerificationCommand(this.m_nodeList[i], args, env);
            }
            Trace.out((String)("about to submit cmd : " + queryDNSCmd));
            new GlobalHandler().submit((Command[])queryDNSCmdArr, 0, locrs);
            this.m_resultSet.uploadResultSet(locrs);
            if (!locrs.anySuccess()) {
                StringBuilder sb = new StringBuilder();
                for (int i2 = 0; i2 < this.m_nodeList.length; ++i2) {
                    String output2 = queryDNSCmdArr[i2].getOutput();
                    if (output2 == null) continue;
                    sb.append(output2 + LSEP);
                }
                this.displayGlobalFailureErrMsg(queryDNSCmd, sb.toString());
                return false;
            }
            for (i = 0; i < this.m_nodeList.length; ++i) {
                Result result = queryDNSCmdArr[i].getResult();
                String node = queryDNSCmdArr[i].getNode();
                if (result.getStatus() == 1) {
                    output = queryDNSCmdArr[i].getOutput();
                    nodeOutputMap.put(this.m_nodeList[i], output);
                    continue;
                }
                output = queryDNSCmdArr[i].getOutput();
                if (output == null) {
                    output = "";
                }
                Trace.out((String)("command failed to execute on node " + node));
                String errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{queryDNSCmd, node, output});
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
            }
        } else {
            GlobalExecution globalExec = new GlobalExecution();
            boolean rootCmdstatus = false;
            try {
                rootCmdstatus = globalExec.runGenericCmdAsRoot(this.m_nodeList, queryDNSCmd, env, args, this.m_rootCreds, this.m_defaultTimeout, locrs);
            }
            catch (RootAutomationNotConfiguredException e) {
                locrs.addResult(this.m_nodeList, 2);
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                locrs.addErrorDescription(errDesc);
                return false;
            }
            this.m_resultSet.uploadResultSet(locrs);
            if (locrs.anySuccess()) {
                Trace.out((String)"root query dns command execution failed");
                for (int i = 0; i < this.m_nodeList.length; ++i) {
                    List<VerificationError> errList = locrs.getResult(this.m_nodeList[i]).getErrors();
                    StringBuilder sb = new StringBuilder();
                    for (VerificationError vfyErr : errList) {
                        sb.append(vfyErr.getErrorMessage());
                    }
                    this.displayGlobalFailureErrMsg(queryDNSCmd, sb.toString());
                }
                return false;
            }
            for (int i = 0; i < this.m_nodeList.length; ++i) {
                Result result = locrs.getResult(this.m_nodeList[i]);
                if (result.getStatus() == 1) {
                    output = (String)locrs.getResult(this.m_nodeList[i]).getResultInfoSet().get(0);
                    nodeOutputMap.put(this.m_nodeList[i], output);
                    continue;
                }
                List<VerificationError> errList = locrs.getResult(this.m_nodeList[i]).getErrors();
                StringBuilder sb = new StringBuilder();
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
                String errMsg = s_msgBundle.getMessage("5718", true, (Object[])new String[]{queryDNSCmd, this.m_nodeList[i], ""}) + LSEP + sb.toString();
                ErrorDescription errDesc = new ErrorDescription(errMsg);
                Trace.out((String)("error on node " + this.m_nodeList[i] + " is " + sb.toString()));
                this.m_resultSet.addErrorDescription(this.m_nodeList[i], errDesc);
                ReportUtil.sureprintln(errMsg);
            }
        }
        for (Map.Entry entry : nodeOutputMap.entrySet()) {
            ErrorDescription errDesc;
            String errMsg;
            output = (String)entry.getValue();
            String node = (String)entry.getKey();
            Trace.out((String)("output =" + output));
            if (output == null || output.length() == 0) {
                this.displayNoOutputErrorMsg(queryDNSCmd, node);
                continue;
            }
            if (output.indexOf("CRS-10023:") != -1) {
                Trace.out((String)"sent name lookup but no response as expected");
                this.m_resultSet.addResult(node, 1);
                ReportUtil.sureprintln(s_gMsgBundle.getMessage("5800", false, (Object[])new String[]{fullHostName}));
                continue;
            }
            if (output.indexOf("CRS-4047:") != -1) {
                Trace.out((String)"could not complete name lookup");
                this.m_resultSet.addResult(node, 3);
                errMsg = null;
                errMsg = dnsServerAddress == null ? s_msgBundle.getMessage("5823", true, (Object[])new String[]{fullHostName}) : s_msgBundle.getMessage("5822", true, (Object[])new String[]{fullHostName, this.m_gnsIP, this.m_gnsPort});
                errMsg = errMsg + LSEP + output;
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(node, errDesc);
                ReportUtil.sureprintln(errMsg);
                continue;
            }
            if (output.indexOf(fullHostName) != -1) {
                Trace.out((String)"name resolution successful");
                this.m_resultSet.addResult(node, 1);
                continue;
            }
            this.m_resultSet.addResult(node, 2);
            errMsg = s_msgBundle.getMessage("5714", true, (Object[])new String[]{queryDNSCmd, output});
            errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addErrorDescription(node, errDesc);
            ReportUtil.sureprintln(errMsg);
        }
        return status;
    }

    private boolean performServerSideChecks() {
        boolean status = true;
        String startIPCmd = this.m_crsctlBinLocation + "bin" + FILE_SEPARATOR + this.START_IP_COMMAND + this.m_gnsVIP;
        if (!this.executeCrsctlCommands(startIPCmd, crsctlCmdType.StartIP)) {
            Trace.out((String)"failed start IP");
            return false;
        }
        try {
            Thread.currentThread();
            Thread.sleep(5000L);
        }
        catch (InterruptedException ie) {
            Trace.out((String)"woken out of sleep");
            Trace.out((String)ie.getMessage());
        }
        String logDir = VerificationUtil.getCVHome() + "cv" + FILE_SEPARATOR + "log";
        String traceLoc = VerificationUtil.getTraceLoc();
        if (traceLoc != null) {
            logDir = traceLoc;
        }
        Trace.out((String)"starting test dns server");
        String startTestDNSCmd = this.m_crsctlBinLocation + "bin" + FILE_SEPARATOR + this.ODNSD_COMMAND + logDir + " -address " + this.m_gnsIP + " -domain " + this.m_gnsDomain + " -verbose";
        if (!this.m_gnsPort.equalsIgnoreCase("53")) {
            startTestDNSCmd = startTestDNSCmd + " -port " + this.m_gnsPort;
        }
        Trace.out((String)("about to start command " + startTestDNSCmd));
        Process proc = null;
        String output = null;
        if (!this.m_isUnix || !this.m_isRootCredsAvaliable) {
            Runtime rt = Runtime.getRuntime();
            try {
                proc = rt.exec(startTestDNSCmd);
            }
            catch (IOException e) {
                Trace.out((String)("exec exception:" + e.getMessage()));
                this.displayGlobalFailureErrMsg(startTestDNSCmd, output);
                status = false;
            }
            ODNSDOutputMonitor outputThread = new ODNSDOutputMonitor(proc, s_gMsgBundle);
            outputThread.start();
            try {
                Trace.out((String)"Waiting for odnsd process to complete");
                Thread.yield();
                proc.waitFor();
                outputThread.join();
            }
            catch (InterruptedException e) {
                Trace.out((String)"Interrupted while awaiting odnsd termination");
            }
        } else {
            String[] nodeArr = new String[]{this.m_nodeList[0]};
            String[] env = null;
            String[] args = null;
            ResultSet locrs = new ResultSet();
            GlobalExecution globalExec = new GlobalExecution();
            try {
                status = globalExec.runGenericCmdAsRoot(nodeArr, startTestDNSCmd, env, args, this.m_rootCreds, this.m_defaultTimeout, locrs);
            }
            catch (RootAutomationNotConfiguredException e) {
                status = false;
                locrs.addResult(nodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                locrs.addErrorDescription(errDesc);
            }
            this.m_resultSet.uploadResultSet(locrs);
        }
        String stopIPCmd = this.m_crsctlBinLocation + "bin" + FILE_SEPARATOR + this.STOP_IP_COMMAND + this.m_gnsIP + "/" + this.m_interface;
        if (!this.executeCrsctlCommands(stopIPCmd, crsctlCmdType.StopIP)) {
            Trace.out((String)"failed stop IP");
            status = false;
        }
        return status;
    }

    private boolean executeCrsctlCommands(String execCmd, crsctlCmdType cmdType) {
        String msg;
        String output = null;
        String node = this.m_nodeList[0];
        ResultSet locrs = new ResultSet();
        String[] env = null;
        String[] args = null;
        if (!this.m_isUnix || !this.m_isRootCredsAvaliable) {
            VerificationCommand[] cmdArray = new VerificationCommand[1];
            args = new String[]{"-rungencmd", execCmd};
            cmdArray[0] = new VerificationCommand(node, args, env);
            Trace.out((String)("about to submit cmd : " + execCmd));
            new GlobalHandler().submit((Command[])cmdArray, 0, locrs);
            this.m_resultSet.uploadResultSet(locrs);
            if (!this.m_resultSet.anySuccess()) {
                output = cmdArray[0].getOutput();
                this.displayGlobalFailureErrMsg(execCmd, output);
                return false;
            }
            Result result = cmdArray[0].getResult();
            if (result.getStatus() == 1) {
                output = cmdArray[0].getOutput();
            }
        } else {
            String[] nodeArr = new String[]{node};
            GlobalExecution globalExec = new GlobalExecution();
            Trace.out((String)("running " + execCmd + " as root"));
            boolean result = false;
            try {
                result = globalExec.runGenericCmdAsRoot(nodeArr, execCmd, env, args, this.m_rootCreds, this.m_defaultTimeout, locrs);
            }
            catch (RootAutomationNotConfiguredException e) {
                locrs.addResult(nodeArr, 2);
                ErrorDescription errDesc = new ErrorDescription(e.getMessage());
                locrs.addErrorDescription(errDesc);
            }
            this.m_resultSet.uploadResultSet(locrs);
            if (locrs.getStatus() != 1) {
                List<VerificationError> errList = locrs.getResult(this.m_nodeList[0]).getErrors();
                Trace.out((String)"root command execution failed");
                StringBuilder sb = new StringBuilder();
                for (VerificationError vfyErr : errList) {
                    sb.append(vfyErr.getErrorMessage());
                }
                this.displayGlobalFailureErrMsg(execCmd, sb.toString());
                return false;
            }
            output = (String)locrs.getResult(this.m_nodeList[0]).getResultInfoSet().get(0);
        }
        Trace.out((String)("output =" + output));
        if (output == null || output.length() == 0) {
            msg = null;
            if (cmdType == crsctlCmdType.StartIP) {
                msg = s_msgBundle.getMessage("5802", false, (Object[])new String[]{this.m_gnsVIP, node});
            } else if (cmdType == crsctlCmdType.StartDNS) {
                msg = s_msgBundle.getMessage("5806", false, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
            } else if (cmdType == crsctlCmdType.StopIP) {
                msg = s_msgBundle.getMessage("5808", false, (Object[])new String[]{this.m_gnsIP, node});
            }
            ReportUtil.println(msg);
            this.m_resultSet.addResult(node, 1);
        } else {
            ErrorDescription errDesc;
            String errMsg;
            if (output.indexOf("CRS-4000:") != -1 || output.indexOf("CRS-4047:") != -1) {
                this.m_resultSet.addResult(node, 2);
                errMsg = null;
                if (cmdType == crsctlCmdType.StartIP) {
                    errMsg = s_msgBundle.getMessage("5803", true, (Object[])new String[]{this.m_gnsVIP, node});
                } else if (cmdType == crsctlCmdType.StartDNS) {
                    errMsg = s_msgBundle.getMessage("5809", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
                } else if (cmdType == crsctlCmdType.StopDNS) {
                    errMsg = s_msgBundle.getMessage("5810", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
                } else if (cmdType == crsctlCmdType.StopIP) {
                    errMsg = s_msgBundle.getMessage("5811", true, (Object[])new String[]{this.m_gnsIP, node});
                }
                errMsg = errMsg + LSEP + output;
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
            if (output.indexOf("CRS-10031:") != -1 || output.indexOf("CRS-10032:") != -1) {
                msg = s_msgBundle.getMessage("5807", false, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort});
                ReportUtil.println(msg);
                this.m_resultSet.addResult(node, 1);
            } else {
                if (output.indexOf("CRS-10033:") != -1 || output.indexOf("CRS-10034:") != -1) {
                    Trace.out((String)"couldn't stop dns server");
                    this.m_resultSet.addResult(node, 2);
                    errMsg = s_msgBundle.getMessage("5810", true, (Object[])new String[]{this.m_gnsIP, this.m_gnsPort}) + LSEP + output;
                    errDesc = new ErrorDescription(errMsg);
                    this.m_resultSet.addErrorDescription(errDesc);
                    ReportUtil.sureprintln(errMsg);
                    return false;
                }
                this.m_resultSet.addResult(node, 2);
                errMsg = s_msgBundle.getMessage("5714", true, (Object[])new String[]{execCmd, output});
                errDesc = new ErrorDescription(errMsg);
                this.m_resultSet.addErrorDescription(errDesc);
                ReportUtil.sureprintln(errMsg);
                return false;
            }
        }
        return true;
    }

    private boolean getCmdLineParams() {
        String tmpGnsIP;
        try {
            ParamManager pm = ParamManager.getInstance();
            this.m_server = pm.checkArgServer();
            this.m_client = pm.checkArgClient();
            this.m_lastClient = pm.checkArgLastClient();
        }
        catch (UninitializedParamManagerException e) {
            Trace.out((Exception)e);
        }
        if (this.m_server) {
            this.m_gnsVIP = VerificationUtil.getVariableValue("GNS_VIP_FULL_ADDRESS");
            tmpGnsIP = this.m_gnsVIP.substring(0, this.m_gnsVIP.indexOf("/"));
            this.m_interface = this.m_gnsVIP.substring(this.m_gnsVIP.lastIndexOf("/") + 1, this.m_gnsVIP.length());
            Trace.out((String)("vip = " + this.m_gnsIP));
            Trace.out((String)("interface = " + this.m_interface));
        } else {
            tmpGnsIP = this.m_gnsVIP = VerificationUtil.getVariableValue("GNS_VIP_ADDRESS");
        }
        try {
            InetAddress tempGNSInetAddr = InetAddress.getByName(tmpGnsIP);
            this.m_gnsIP = tempGNSInetAddr.getHostAddress();
        }
        catch (UnknownHostException e) {
            Trace.out((String)"uhe while translating gns vip");
            String errMsg = s_msgBundle.getMessage("5227", true, (Object[])new String[]{tmpGnsIP});
            ReportUtil.sureprintln(errMsg);
            ErrorDescription errDesc = new ErrorDescription(errMsg);
            this.m_resultSet.addResult(this.m_nodeList, 2);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        String inputPort = VerificationUtil.getVariableValue("DNS_PORT");
        if (inputPort != null) {
            this.m_gnsPort = inputPort;
        }
        this.m_gnsDomain = VerificationUtil.getVariableValue("GNS_SUB_DOMAIN");
        try {
            GNSUtils gnsUtils = new GNSUtils();
            boolean isValid = GNSUtils.isDomainNameValid((String)this.m_gnsDomain);
        }
        catch (GNSException e) {
            String msg = s_msgBundle.getMessage("5826", true, (Object[])new String[]{this.m_gnsDomain}) + LSEP + e.getMessage();
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        try {
            InetAddress.getByName(this.m_gnsIP);
        }
        catch (UnknownHostException e) {
            String msg = s_msgBundle.getMessage("5227", true, (Object[])new String[]{this.m_gnsIP});
            ReportUtil.sureprintln(msg);
            this.m_resultSet.addResult(this.m_nodeList, 3);
            ErrorDescription errDesc = new ErrorDescription(msg);
            this.m_resultSet.addErrorDescription(this.m_nodeList, errDesc);
            return false;
        }
        return true;
    }

    private void displayNoOutputErrorMsg(String execCmd, String node) {
        Trace.out((String)("no output from command: " + execCmd + "on node: " + node));
        this.m_resultSet.addResult(node, 2);
        String errMsg = s_msgBundle.getMessage("5713", true, (Object[])new String[]{execCmd, node});
        ErrorDescription errDesc = new ErrorDescription(errMsg);
        this.m_resultSet.addErrorDescription(node, errDesc);
        ReportUtil.sureprintln(errMsg);
    }

    private void displayGlobalFailureErrMsg(String execCmd, String output) {
        Trace.out((String)("Global failure executing command " + execCmd));
        String message = s_msgBundle.getMessage("5801", true, (Object[])new String[]{execCmd});
        if (output != null) {
            message = message + LSEP + output;
        }
        ErrorDescription errorDesc = new ErrorDescription(message);
        this.m_resultSet.addErrorDescription(this.m_nodeList, errorDesc);
        this.m_resultSet.addResult(this.m_nodeList, 2);
        ReportUtil.sureprintln(message);
    }

    private static enum crsctlCmdType {
        StartIP,
        StartDNS,
        StopDNS,
        StopIP;

    }
}

